# 第九章 开源贡献
 
时至今日，在全球开源界普遍认同中国企业和中国开发者对全球开源产业贡献巨大的背景下，依然有许多国内人士认为中国是全球开源资源的索取者和使用者，这是成见，更是偏见。

事实上，在20世纪90年代中期，中国开源还处于启蒙阶段，国内最早接触这一领域的技术先驱者尝试积极参与国际开源社区的代码共享活动，虽然是凤毛麟角，但星星之火终成燎原之势。

21世纪初，随着国内Linux系统和LAMP技术栈的兴起，中国开源进入萌芽阶段，一些全球知名企业在华研究机构成建制地组织中国开发者，系统地参与到国际知名开源社区中。国内开源社区如雨后春笋般层出不穷，开源文化在当时那一批20岁出头的中国开发者心中埋下了种子。

时间来到2008年，这一年是中国开源发展史上的重要里程碑，Linux基金会、GNOME基金会、Apache软件基金会以及OpenOfﬁce基金会不约而同地选择在北京举办相关技术峰会，实现了他们登录亚洲的首秀。因此，2008年成为一个重要的转折点，全球开源界已经承认中国的开源贡献者地位，中国开源的第三个发展阶段随之到来。

在过去13年中，中国开源开发者开始习惯于用流利的英语和全球开源人士分享他们的技术经验。根据中国开源软件推进联盟统计，在2016年至2017年在华召开的开源国际会议上发表的论文中，来自国内和国外的的论文比例为4：6，即有40%的开源论文来自中国开发者。

中国的开源力量正在以惊人的速度迎头赶上，在开源开发者贡献度、开源社区活跃度、开源基金会参与度等方面，我们均已取得不俗的成绩。这些来自中国的开发者和科技企业正在向全世界呈现全新的中国印象，中国逐步实现了开源世界的大国担当。

本章将引用全球知名开源基金会和业内最具代表性的开源社区的详实数据，来呈现开源世界的中国贡献，以及国际企业对中国开源发展所带来的推动作用。

## 9.1 国际开源社区的中国贡献

### 9.1.1 中国开发者已经成为Kernel.org社区最大贡献群体

在开源世界中，Kernel.org社区的象征意义无可替代，开源界的创世一代至今依然活跃在这个社区，因而Kernel.org至今仍常被作为一个开源指数来度量一个企业或一个区域的开源繁荣和发展程度。

为更加全面地展示中国在开源领域的成长过程，我们分别通过中国开发者和中国科技企业对Kernel.org社区的补丁贡献数据来呈现(见图28)。

![请添加图片描述](https://img-blog.csdnimg.cn/0956a569098246718b1cf01e6b965375.png)
<span style="font-size:10px;color:#707070;text-align:left !important;display: block;line-height:1.5em;"><br>图28 中国开发者对Kernel.org社区的贡献数据和贡献度排名（2005年6月至2022年2月）</span>


为了更直观地呈现内核社区中中国开发者的参与度和贡献度的变化，我们节选了部分版本的贡献度进行对比，从表22可看出，在过去的16年间，参与Kernel.org社区的中国开发者的规模提升了34倍， 对社区的贡献绝对数量提升了34.76%，对Kernel.org的贡献排名近五年来保持世界第一。


![请添加图片描述](https://img-blog.csdnimg.cn/f6bedd22a5aa43c3a84e1107807bb7e8.jpeg)
<span style="font-size:10px;color:#707070;text-align:left !important;display: block;line-height:1.5em;"><br>表22 部分版本贡献度对比（数据采集截至2022年2月21日）</span>

在统计过程中，我们还有一些发现。通过对比12年来中国开发者数量的变化，可以推算出中国开发者对Kernel.org社区的人均贡献度，其整体变化如图29所示。

![请添加图片描述](https://img-blog.csdnimg.cn/793c384a17a64005a7c55882b52b8192.png)
<span style="font-size:10px;color:#707070;text-align:left !important;display: block;line-height:1.5em;"><br>图29 中国开发者对Kernel.org社区的人均贡献度（2005年6月至2022年2月）</span>

通过对比最近三个内核版本排名前三国家的开发者人数和人均贡献值(见表23)，可以发现现今中国开发者的人均贡献度远小于德国和美国，进而我们可以推断出未来中国开发者的人均贡献度和绝对贡献数量还有很大提升空间。

![请添加图片描述](https://img-blog.csdnimg.cn/092ff1a0416e4572afb7a7dae091d78e.jpeg)
<span style="font-size:10px;color:#707070;text-align:left !important;display: block;line-height:1.5em;"><br>表23 Kernel.org社区三个内核版本排名前三国家的开发者人数和人均贡献值</span>

纵观Kernel.org社区总体的开发者贡献，我们会发现中国、美国、德国、英国、法国、印度是该社区的主要贡献群体，其中中国的发展速度远远超过上述其他国家(见图30)。

![请添加图片描述](https://img-blog.csdnimg.cn/0a512241d37c4927a9f9530153f6ffca.png)
<span style="font-size:10px;color:#707070;text-align:left !important;display: block;line-height:1.5em;"><br>图30 主要国家开发者在Kernel.org社区的贡献排名（2005年6月至2022年2月）</span>

从另一个角度，我们同样可以发现中国企业在Kernel.org社区中的贡献度越来越大，相关排名持续上升，图31是2017年2月至2022年2月的中国企业内核社区贡献排名。

![请添加图片描述](https://img-blog.csdnimg.cn/fa054edbd4ad4895a1352565edce2edd.png)
<span style="font-size:10px;color:#707070;text-align:left !important;display: block;line-height:1.5em;"><br>图31 十大中国企业在Kernel.org社区中的贡献排名（2017年2月至2022年2月）</span>

此外，联想、酷派、麒麟软件和小米均对内核社区有贡献。


### 9.1.2 中国开发者成为RISC-V生态中不可或缺的组成部分

2011年5月，加州大学伯克利分校研究团队发布了一套全新的开放指令集RISC-V(见图32)。2015年，汇聚全球100多家单位的非营利组织RISC-V基金会正式成立。

![请添加图片描述](https://img-blog.csdnimg.cn/0c1adb5f55994be9aecd04b09d0d34b3.png)
<span style="font-size:10px;color:#707070;text-align:left !important;display: block;line-height:1.5em;"><br>图32 RISC-V指令集</span>

为降低潜在的技术出口法律限制风险，减轻来自地缘政治的潜在破坏，同时为确保基金会更加中立、开放和包容，RISC-V基金会将注册地迁移至瑞士，此举受到全球RISC-V爱好者的广泛好评。RISC-V基金会的日常运营由董事会负责，由四名常委和十六名委员构成，其中的中方委员有九名(见表24)，占比达到45%。

![请添加图片描述](https://img-blog.csdnimg.cn/06784e16213e4897a2914b6861fd5de8.jpeg)
<span style="font-size:10px;color:#707070;text-align:left !important;display: block;line-height:1.5em;"><br>表24 RISC-V理事会中方委员</span>

在RISC-V这一轮发展浪潮中，中国企业、高校和科研机构发挥了巨大作用。有数据显示，中国有超过400家企业关注、参与和使用RISC-V指令集进行开发。据统计，在RISC-V基金会中，成员分为三个层次(见表25)，在基金会核心成员( Premier Member)中，中方成员占比达到57.9%。在战略成员(Strategic Member)中，中方成员占比达到26.8%，在社区组织成员(Community Organization Member)中，中方成员占比达到7.6%。

![请添加图片描述](https://img-blog.csdnimg.cn/2fa920e77ecb44abb6a8372cb48e1020.jpeg)
<span style="font-size:10px;color:#707070;text-align:left !important;display: block;line-height:1.5em;"><br>表25 RISC-V理事会中方成员</span>    

特别是2018年以来，RISC-V在中国的发展呈现加速之势，以下为相关标志性事件。

2018年2月，《RISC-V手册》中文版出版。

2018年5月，胡振波撰写的《手把手教你设计CPU——RISC-V处理器》正式出版。

2018年7月，上海经信委出台了国内首个支持RISC-V的政策。

2018年9月，中国RISC-V产业联盟在上海成立。

2018年9月，华米科技发布基于RISC-V的可穿戴处理器“黄山1号”。

2018年11月，中国开放指令生态(RISC-V)联盟在乌镇成立。

2019年1月，《开放指令集与开源芯片发展报告》发布。

2019年6月，世界智能计算机大会开源芯片论坛在深圳举办。

2019年7月，阿里平头哥正式发布RISC-V处理器玄铁910。

2019年9月，中国开放指令生态联盟联合BenchCouncil举办RISC-V国际智能系统大赛。2019年10月，阿里平头哥宣布开源RISC-V的MCU平台无剑100 Open。

2019年10月，卡姆派乐发布RISC-V集成开发环境-卡姆派乐IDE。

2019年11月，清华-伯克利深圳学院设立RIOS实验室，图灵奖得主大卫帕特森领衔。2019年11月，中国RISC-V论坛在深圳召开。

2020年1月，上海交通大学与上海瓶钵信息科技有限公司开源了基于RISC-V架构的TEE安全系统“蓬莱”。

2020年3月，兆易创新GD32MCU获Embedded Award 2020国际顶级大奖。

2020年4月，芯来科技发布“Nuclei RISC-V大学计划”。

2020年6月，“香山”开源高性能处理器项目启动。

2020年6月，华米科技发布基于RISC-V的“黄山2号”可穿戴AI芯片。

2020年7月，中国开放指令生态联盟举办2020年度联盟技术研讨会。

2020年7月，中国科学院大学发布针对RISC-V处理器的“一生一芯”计划。

2020年8月，卡姆派乐公司开源RISC-V向量LLVM编译器。

2020年8月，RIOS发布全球首个运行Linux的RISC-V开源边缘计算平台PicoRio。

2021年8月，中科院软件所与RISC-V国际基金会联合上线全球首个面向开源社区的RISC-V构建验证平台RISC-V Lab。

2020年9月，RIOS的曹野移植Chromium OS到RISC-V。

2020年9月，赛昉科技发布基于RISC-V人工视觉处理平台——惊鸿7100。

2020年11月，RT-Thread发布RISC-V的国产集成开发环境RT-Thread Studio。

2020年11月，千芯科技发布针对芯来RISC-V平台的AI部署工具包(tinyAI SDK)。

2020年12月，芯来科技推出开源RISC-V处理器教学平台——蜂鸟E203 SoC。

2021年1月，阿里平头哥为RISC-V移植安卓10系统并开源。

2021年2月，平头哥携手阿里云天池举办“RISC-V应用创新大赛”。

2021年3月，中科蓝讯RISC-V指令集蓝牙芯片累计超过10亿颗。

2021年4月，芯来科技为RISC-V移植了鸿蒙LiteOS-M内核。

2021年5月，华为海思推出基于RISC-V的Hi3861的开发板。

2021年6月，阿里平头哥推出三款RISC-V开发板，分别支持Android、Linux、AliOS Things。2021年6月，首届RISC-V中国峰会在上海召开。

2021年7月，“香山”第一版处理器“雁栖湖”(28nm)正式流片。

2021年8月，赛昉科技累计融资10亿元。

2021年9月，睿思芯科完成A轮数千万美金投资。

2021年10月，阿里平头哥开源四款RISC-V处理器E902、E906、C906和C910。2021年10月，2021 RISC-V Taipei Day召开。

2021年11月，中国科学院软件研究所《RISC-V指令集架构研究综述》论文发表。

2021年12月，赛昉科技发布RISC-V CPU Core IP“昉·天枢”和“昉·星光”RISC-V单板计算机。2021年12月，阿里平头哥宣布RISC-V玄铁处理器累计出货超过25亿颗。

2021年12月，华为海思基于RISC-V发布Hi373V110电视芯片及LiteOS。

在上述标志性事件中，我们可以看出，在2018年12月RISC-V基金会首次宣布要迁至瑞士后，中国企业界和学术界加速了参与和融入RISC-V基金会的进程，其中中国RISC-V产业联盟和中国开放指令生态(RISC-V)联盟发挥了巨大的促进作用。自2020年开始，中国国内的RISC-V生态快速完善，并开始涌现越来越多的RISC-V产业化案例。

众所周知，中国一直在芯片领域处于受制于人的窘境，整个产业迫切走出一条自力更生、自主创新之路。RISC-V由于开源的特性，自诞生起就在中国产业界备受瞩目，大量中国芯片公司正在成为RISC-V的拥趸，加大对RISC-V的投入。而中国具备的电子制造业生态优势，也成为RISC-V应用前景最乐观的地区，RISC-V在中国的市场容量和发展潜力巨大。这些因素成就了双方“互利互助、合作共赢”的天作之合。

另外，RISC-V生态中的相应软件、工具链还有待完善。RISC-V指令集开源并不意味着CPU核心也同时免费授权，这对芯片公司提出了很高的设计和研发要求。客观上，目前RISC-V只是帮中国芯片产业走上快车道，但前路漫漫，还需要我们持续努力。在未来的RISC-V生态建设中，中国企业需要平心静气、戒骄戒躁，避免在资本的推动下过度炒作概念，同时加强全球产业合作，避免产业生态碎片化趋势。

### 9.1.3 中国用户和开发者已经成为OpenCV社区的中坚力量

最近十年，中国成为开源计算机视觉软件OpenCV最大用户。根据Sourceforge.net的统计(见图33)，2012年中国下载量排在美国、日本之后。2013年开始，中国超越美国和日本位居第一。此后，中国下载量占全球比例持续增加，至2021年已达41.4%，即全球下载量超过四成来自中国。随着人工智能领域的发展，中国已经成为OpenCV第一大用户，远超其他国家。

![请添加图片描述](https://img-blog.csdnimg.cn/9b18ff4178b64bde9e57cb3d65790866.png)
<span style="font-size:10px;color:#707070;text-align:left !important;display: block;line-height:1.5em;"><br>图33 OpenCV四国年度下载量</span>

OpenCV最初由Intel公司在俄罗斯的研发团队开发，于2000年正式对外发布。现在OpenCV已由OpenCV基金会社区化运作，有来自全世界各地的开发者为之贡献代码。由于历史原因，很多关键功能都是由来自俄罗斯的开发者提供。这些开发者或来自俄罗斯的Intel、Xperience.ai等公司。

与此同时，在OpenCV社区中的中国开发者贡献比例也在起伏攀升(见图34)。以Google Summer of Code为例，2017年至2021年，Google共资助OpenCV 48个项目，其中14个由中国开发者承担，占比29.2%。在此之前的2011年至2016年，中国开发者仅占8.4%(6/71)。OpenCV的Area Chair，是一个招募高级科学家为OpenCV做算法贡献的社区项目，据2022年OpenCV春季公布的首批OpenCV Area Chair，共有9人，其中4名是中国科学家，占比44.4%。南方科技大学的于仕琪教授是GitHub上OpenCV项目的管理员之一，具有代码管理权限。

![请添加图片描述](https://img-blog.csdnimg.cn/2efdd44dec6f4412bde6ad108b8929b6.png)
<span style="font-size:10px;color:#707070;text-align:left !important;display: block;line-height:1.5em;"><br>图34 历年OpenCV GSoc项目中国开发者比例</span>

2019年，OpenCV中国团队成立，得到深圳市人工智能与机器人研究院和南方科技大学的支持。OpenCV近两年在中国的发展得益于OpenCV中国团队的助力，该团队致力于引导中国开发力量为OpenCV做贡献，使中国科研成果普惠全世界；同时改进OpenCV使之适应未来的应用，特别是机器人相关应用，促进科研成果快速落地。

OpenCV开发团队负责人Vadim Pisarevsky于2019年正式移居深圳，全职加入OpenCV中国团队。在他的带领下，OpenCV中国团队一方面进行核心模块的设计和开发，另一方面进行推广和培训。与此同时，Vadim Pisarevsky和于仕琪教授皆是OpenCV基金会董事成员，积极推动了OpenCV基金会的社区化改革，提议OpenCV Development Partnership、OpenCV Membership和OpenCV Area Chair三个方案，这三个方案皆被OpenCV基金会接受并实施。

2020年，OpenCV启动OpenCV Development Partnership计划，招募有意为OpenCV做贡献且在OpenCV生态链的公司加入，陆续有开放智能机器(上海)有限公司、奥比中光科技集团股份有限公司、深圳市世野科技有限公司等多家中国公司加入。OpenCV基金会于2021年正式对外开放OpenCV Membership，招募企业会员。2021年底，华为公司正式加入OpenCV基金会，成为OpenCV会员。最近两年，中科院软件所、阿里平头哥公司为OpenCV贡献了非常核心的RISC-V CPU支持；腾讯公司为OpenCV贡献了QR二维码扫码算法；北京邮电大学、华中科技大学、南方科技大学等高校为OpenCV贡献了大量关键视觉算法。

## 9.2 中国企业在开源基金会中发挥重要作用

### 9.2.1 中国成员在Apache软件基金会（ASF）的参与度

截至2022年6月，Apache软件基金会源自中国的活跃开源项目共28个，其中有17个项目成为了顶级项目。分别是：

* Apache Doris(2018/07/18-2022/6/15)
* Apache InLong(原TubeMQ，2019/11/03-2022/6/15)
* Apache DolphinScheduler(2019/8/29-2021/04/08)
* Apache ECharts(2018/1/18-2020/12/16)
* Apache Ozone(2018/11-22-2020/10/21)
* Apache IoTDB(2018/11/18-2020/9/17)
* Apache APISIX(2019/10/17-2020/07/15)
* Apache ShardingSphere(2018/11/10–2020/4/16)
* Apache Submarine(2019/10/16,Hadoop spin-off)
* Apache Dubbo(2018/2/16–2019/5/15)
* Apache Skywalking(2017/12/8–2019/4/17)
* Apache Grifﬁn(2016/12/5–2018/11/21)
* Apache ServiceComb(2017/11/22–2018/10/17)
* Apache HAWQ(2015/9/4–2018/8/15)
* Apache RocketMQ(2016/11/21–2017/9/20)
* Apache CarbonData(2016/6/3–2017/4/19)
* Apache Kylin(2014/11/25–2015/11/18)

在Apache软件基金会孵化项目中，中国项目有11个，2021年、2022年截至4月分别有5个和3个新项目进入到ASF项目孵化器。11个孵化项目分别是：

* Apache DevLake(2022/04/29)
* Apache Kvrocks(2022/04/23)
* Apache HugeGraph(2022/01/23)
* Apache SeaTunnel(2021/12/09)
* Apache Linkis(2021/08/02)
* Apache Kyuubi(2021/06/21)
* Apache ShenYu(2021/05/03)
* Apache EventMesh(2021/02/18)
* Apache Pegasus(2020/06/22)
* Apache Teaclave(原MesaTEE,2019/08/19)
* Apache brpc(2018/11/13)

ASF全球有800余位成员，目前已知并互动较为频繁的中国及华人成员有29位。其中，姜宁在2022年3月ASF举行的成员会议上被选举成为新任董事。

Apache软件基金会现有中国企业赞助商6家(见表26)，分别是白金赞助商：华为、腾讯云；黄金赞助商：百度；白银赞助商：阿里云、滴滴出行；银牌赞助商：小米。

![请添加图片描述](https://img-blog.csdnimg.cn/694c8f6128784624912501e8c1c79980.jpeg)
<span style="font-size:10px;color:#707070;text-align:left !important;display: block;line-height:1.5em;"><br>表26 Apache基金会中国赞助商明细表</span>

### 9.2.2 中国成员在Linux基金会（LF）的参与度

Linux基金会董事会成员共23人，其中中国成员2人，占比为8.6%。分别为华为的侯培新与腾讯的刘鑫。

Linux基金会目前共有中国会员139家(见表27)，相较于2020年的70家增涨了98.6%。其中白金会员2家(约占14.3%)；黄金会员3家(约占16.7%)；白银会员112家(约占9.5%)；Associate(准会员)22家(约占7.9%)。

![请添加图片描述](https://img-blog.csdnimg.cn/de71a5261012425da398aff7a853fee0.jpeg)
<span style="font-size:10px;color:#707070;text-align:left !important;display: block;line-height:1.5em;"><br>表27 LF中国成员单位明细表</span>

### 9.2.3 中国成员在云原生计算基金会（CNCF）的参与度

据CNCF的统计，超过20%的开源项目来自中国，贡献度排名上升至世界第二。在云原生应用上，68%的机构在生产过程中使用容器，31%的开发者称所在单位的容器使用量已经超过5000个。CNCF理事会共29名成员，其中中国成员2人，分别是阿里巴巴的李毅和火山引擎(字节跳动)的张鑫。

CNCF基金会目前共有中国会员84家(见表28)，其中包括3个白金会员(占13.6%)、10个黄金会员(占40%)、67个白银会员(占11.1%)、1个研究院所(占25%)，以及3个最终用户会员(占2.9%)。中国会员目前占CNCF总数的10.7%，较2021年统计增长了2.7%。

![请添加图片描述](https://img-blog.csdnimg.cn/62b33999e5b947cb843ccbfdd6cc036b.jpeg)
<span style="font-size:10px;color:#707070;text-align:left !important;display: block;line-height:1.5em;"><br>表28 CNCF中国成员明细表</span>	　	　

### 9.2.4 中国成员在开源基础设施基金会（OIF）的参与度

OIF基金会董事会27人，其中中国成员11人(占40.7%)。分别为烽火通信陈刚；易捷行云李中华、林冠宇；中国移动焦鹏举；中国联通钟忻；英特尔练丽萍、王伟；九州云李开；腾讯任钟坪；蚂蚁集团王旭；华为任旭东。OIF现有中国成员中包括白金会员4家(占44%)；黄金会员9家(占53%)；白银会员1家(2.2%)；支持机构14家(占4%)，见表29。

![请添加图片描述](https://img-blog.csdnimg.cn/88df031503fb4f4e8b58cd0acb4b8d54.jpeg)
<span style="font-size:10px;color:#707070;text-align:left !important;display: block;line-height:1.5em;"><br>表29 OIF社区中国成员明细表</span>	

### 9.2.5 中国成员在开源发明网络社区（OIN）的参与度

目前OIN社区现有中国成员共125个(见表30)，较2021年统计增长26%。

![请添加图片描述](https://img-blog.csdnimg.cn/61f1ed1e157547c5a2659f21217c98f7.jpeg)
<span style="font-size:10px;color:#707070;text-align:left !important;display: block;line-height:1.5em;"><br>表30 OIN 社区中国成员明细表（部分）</span>	

## 9.3 中国头部科技企业的开源贡献

### 9.3.1 华为

华为公司是国内最早建立开源战略管理的企业之一，在开源合规、企业内源、全球开源贡献、社区融入和技术引领等方面位居国内企业前列。华为是Apache软件基金会、Eclipse基金会、Linux基金会、开放原子开源基金会、OIF基金会等数十个国际开源基金会的顶级成员或初创成员，服务数十个董事席位，以及数百个TSC、PMC、PTL、Maintainer、Core Committer席位。

近两年来，面向云原生、自动化和智能化，华为又先后开源了EdgeGallery、MindSpore、Karmada、openEuler、openGauss、OpenHarmony等多个平台级基础软件开源项目。其中openEuler、OpenHarmony开源项目捐赠给开放原子开源基金会，Karmada开源项目捐赠给CNCF基金会，全球超过1000个城市的用户下载使用这些开源软件。

华为持续投入openEuler、openGauss、OpenHarmony、MindSpore开源项目生态建设，openEuler社区吸引近万名开发者、300+家企业加入，主流操作系统厂家发行11个商业发行版，openEuler商用已经突破100万套；openGauss社区开发者2500+，100家组织加入社区，已发布12个商业发行版，6大行业推广使用10000+套；华为累计贡献500多万行OpenHarmony核心代码，社区吸引30000+名开发者和40家企业参与代码贡献，生态设备发货量1亿+，已在12个行业探索落地；MindSpore社区开发者80万+，新增160+家企业成员，服务5000+家企业。2021年，华为启动“开源雨林”计划，携手国内多家开源组织和科研机构，共同构建面向企业开源理念和治理的社区，帮助国内企业理解开源文化，合理合规使用开源，共同构筑国内开放共赢的健康开源生态。

同时，华为致力于健全社区生态治理架构，确保有序演进。通过社区度量反馈机制，及时了解开发者反馈，持续优化社区治理机制。引入AI技术辅助社区运营，对社区基础设施进行技术优化和智能化，提升用户体验。将优秀编码规范、流程、工具链等引入社区，源源不断地为社区注入活力。基于开源协作的创新模式推动产业生态构建，共建多样性、包容性、可信的开源生态。

**重点开源贡献**

**OpenHarmony** ：这是由开放原子开源基金会孵化及运营的开源项目，目标是面向全场景、全连接、全智能时代。基于开源的方式，搭建一个智能终端设备操作系统的框架和平台，促进万物互联产业的繁荣发展。OpenHarmony最新版本为v3.1，发布于2021年12月30日。更新了23个领域关键特性、20块开发板，累计204个开发样例。截至目前，已成立38个SIG；代码贡献者1783人；贡献单位共计40家；已有25家机构完成捐赠，募集捐赠款1250万元。陈海波、中科院软件所武延军、51CTO张荣超、深开鸿张兆生、华为贾宁、上海交大臧斌宇、华为李英伟7人被选举为OpenHarmony TSC(Technical Steering Committee技术指导委员会)成员；OpenHarmony PMC(Project Management Committee项目管理委员会)扩容至19人；工作委员会成员扩至8家；活动与营销工作组有38家单位成员，6大开发者社区专区建设(CSDN、51CTO、开源中国、思否、电子发烧友、InfoQ)，104个高校阵地(有组织者的高校)。已有2000人进入“OpenHarmony成长计划”并作为布道师进行培养。已将所有生态进展集结成册，形成《OpenHarmony生态专刊》(144页)，2021年12月28日印刷并在南京OpenHarmony开发者见面会首次分发。

**异思MindSpore** ：通过社区合作，面向全场景构建最佳匹配、支持多处理器架构的开放AI架构，为算法工程师和数据科学家提供开发友好、运行高效、部署灵活的体验。目前，昇思MindSpore下载量已超130万，4000+社区贡献者，5000+企业应用上线。其中手机应用日均7亿+调用量，300+主流网络模型实现。在码云上，MindSpore社区共有21个仓库，总Star数达到1.6万+，总PR数超5.2万，主仓库Gitee指数为96分，领跑同类项目。

**openEuler** ：这是由开放原子开源基金会孵化及运营的开源项目。通过社区合作，打造创新平台，构建支持多处理器架构、统一和开放的操作系统openEuler。2021年9月25日OpenEuler全新发布，同时支持服务器、云计算、边缘计算、嵌入式等各种形态设备的需求。支持多样性计算，致力于提供安全、稳定、易用的操作系统；并通过为应用提供确定性保障能力，支持OT领域应用及OT与ICT的融合。至此全新发布的欧拉操作系统可覆盖从IT、CT到OT数字基础设施全场景。作为国内最活跃的开源社区，已有300家以上头部企业加入，8000多名社区开发者持续在社区贡献，90个以上SIG，8000多个代码仓。截至2021年12月31日，个人贡献者占比累计近40%，企业贡献占比累计超60%。其中，万级以上PR贡献企业一名(华为技术)，千级PR贡献企业两名(麒麟、统信)。OpenEuler下载使用用户超过37万。主流操作系统厂商，如麒麟、统信、SUSE、麒麟信安、普华、中科创达等均已发布基于openEuler商业发行版，这些发行版已在及金融、运营商、电力、政府信息中心等重点行业核心系统达90万套以上规模落地。

### 9.3.2 阿里巴巴

阿里巴巴是国内参与开源技术生态建设的企业典范。自2011年至今，阿里累计开源项目超过3000个，代表性的项目包括龙蜥操作系统、Apache RocketMQ、Apache Dubbo、Spring Cloud Alibaba、Nacos、Seata、PolarDB-X、PolarDB for PostgreSQL等，其中由阿里巴巴捐赠并持续维护的Apache RocektMQ、Apache Dubbo均为Apache基金会顶级开源项目，龙蜥操作系统也已经进入开放原子开源基金会的捐赠流程，覆盖操作系统、云原生、大数据、数据库、前端等众多领域。

截至目前，阿里巴巴深度参与国内外顶级开源基金会及组织，包括Linux基金会、CNCF基金会、Apache软件基金会、开放容器组织(OCI)、MariaDB基金会、Eclipse基金会、RISC-V基金会、开放原子开源基金会等，是Linux、MySQL、Redis、JVM、Kubernetes、containerd、Apache Flink、Envoy等知名开源项目的核心贡献者和维护者。以下简要介绍几个核心开源项目中阿里的主要贡献。

**重点开源贡献**

**RISC-V基金会** ：平头哥和阿里云推动RISC-V International组织的技术标准建设，参与20个技术组的工作，并承担了其中7个技术组的Chair/Vice Chair职务；参与3个技术委员会工作，并担任其中1个委员会的Vice Chair一职，输出一项CSI技术平台标准，重点推动Linux、Vector、QEMU等技术对RISC-V的优化支持工作。其中在QEMU社区，合入主枝108个patch，代码11000行，解决了RISC-V 中UXLEN动态变化、Vector扩展等难题，另有Packed、Fast Interrupt、RISU等100+patch在Review中。在Kernel.org社区贡献2万+行代码、200多个补丁，促进玄铁与Linux社区的合作，完善玄铁开源生态。

**Apache Flink** ：以Apache Flink为例，阿里巴巴贡献了近三分之一的Committer。

**Redis** ：在Redis社区，阿里云累计向Redis社区贡献200多个patch，在参与贡献Redis社区的各个企业中排名第二。在目前最具重量级的版本Redis6.0中贡献超过80个patch，排名第二(仅次于Redis Labs)，并得到了原作者的点名致谢。阿里作为Redis社区的杰出贡献者，是社区核心团队的5名成员之一，向Redis社区贡献了Multi-part AOF、Geosearch、Lua replication refactoring等重量级feature，参与制定了Redis 6.2/7.0的Roadmap和发布计划。

**Kubernetes** ：阿里云推动Kubernetes社区新一代调度架构Scheduling Framework的演进和落地，贡献了40+patch；同时引导原生调度能力支持批量任务的发展，向社区贡献协同调度、容量调度、外置队列等核心能力，落地OpenAI、苹果、百度等公司，得到CNCF TOC委员的转发和点赞，一致认为这个工作满足了批量任务和科学计算领域的核心需求。

**TensorFlow&Pytorch** ：在TensorFlow生态中，阿里作为TensorFlow Recommender SIG社区的主要Owner，对SIG中核心的功能EmbeddingVariable进行维护和优化，并参与制定SIG的Roadmap和发布计划。另外，阿里还开源了业界最早完备支持动态shape编译的AI编译器BladeDISC。能够以TensorFlow/PyTorch插件的形式为AI用户E2E提供通用透明的性能优化，也是业内基于MLIR最早能够投入商用的E2E编译框架，此外能够帮助新硬件厂商提供AI框架的新硬件接入支持。

**OpenJDK** ：阿里云累计向OpenJDK社区贡献120+个patch，覆盖OpenJDK 8u、11u、17u以及主干等多个核心版本。阿里云通过社区合作，和Azul、Datadog、红帽等成功将JFR移植回
OpenJDK8u(主流Java版本之一)。阿里云作为RISC-VInternational(RVI)社区Managed Runtime SIG的主要Owner，制定和推动SIG的发展计划，推动OpenJDK社区full-featured RISC-V架构移植项目进入主树。阿里云是OpenJDK社区活跃的长期活跃企业之一，也是国内唯一的Java标准执行委员会(JCP EC)成员。

**Eclipse** ：阿里云累计向Eclipse社区贡献150+个patch，向Eclipse社区开源并主导了Eclipse Jifa项目。阿里云作为战略基石成员，加入Eclipse Adoptium工作组，致力于创建开放、厂商中立的JDK运行环境，支持Java生态发展。

**GraalVM** ：阿里云在GraalVM项目中贡献了22个PR，累计修改代码5418行。阿里云作为GraalVM社区的重要贡献者，向GraalVM 21.2.0、GraalVM 21.0.0版本贡献了提前注册动态加载类，JDK原生序列化等重要特性，阿里云是GraalVM项目咨询理事会唯一的国内企业代表。

**Clang/LLVM** ：阿里云累计向Clang/LLVM社区贡献170+个patch，在RISC-V、AArch64等重要架构编译器后端有系统化的代码贡献，是RISC-V架构编译器生态重要贡献者。在中端IPO、Function Specialization等优化上积极与社区、其他公司合作，共同提升LLVM优化能力。在语言侧，开发和维护C++20 Coroutine，完成大量优化、可调式性等工作，C++20 Coroutine成为Clang/LLVM完整支持的语言特性。目前仍在活跃开发、贡献C++ Modules等重要特性。阿里云也成为第一家加入C++ Committee的国内企业。

### 9.3.3 百度

截至2021年底，百度已在GitHub主导的21个开源组织累计开源项目1000+个，社区贡献者达1.8万+，获得Star总数37万+。飞桨PaddlePaddle、Apollo、超级链等项目飞速发展；Apache Doris开启基金会毕业进程，HugeGraph项目启动捐赠Apache基金会孵化进程，并已获得投票通过。由于版面原因，我们在百度众多开源项目中选择部分代表性项目，分享他们的工作成绩。

**重点开源贡献**

**飞桨(PaddlePaddle)** ：目前，飞桨已凝聚406万开发者，基于飞桨开源深度学习平台创建47.6万个模型，服务15.7万家企事业单位。飞桨助力开发者快速实现AI想法，创新AI应用，作为基础平台支撑越来越多行业实现产业智能化升级。2021年飞桨框架发布了v2.0版本，正式进入了2.0时代，随后又完成了2.1和2.2两个版本的迭代更新。截至2021年12月31日，整体飞桨Family Star数累计109680(增长99%)，开源社区累计提交Commit超过50万次，以PR或Issue提交形式的开源贡献者超过了15000人。飞桨开发者技术专家(PPDE)累计180多位，飞桨开源合作伙伴计划已汇聚33个全球知名开源项目、8个国际开源组织/社区/基金会。飞桨领航团是面向所有深度学习技术爱好者的兴趣社区，目前已在全球建立200+社群。

**阿波罗(Apollo)** ：Apollo自动驾驶开放平台为开发者提供了车辆、硬件选择，以及环境感知、高精定位、路径规划、车辆控制等自动驾驶软件能力，同时包括高精地图、仿真、数据流水线等自动驾驶云服务，帮助开发者从0到1快速搭建一套自动驾驶系统。2021年，Apollo发布了Apollo 6.0 EDU和Apollo 7.0两个版本，其中Apollo 7.0，开放代码70万+行，GitHub Star数19k+。目前Apollo开发者社区已经拥有来自全球135个国家，80000多名开发者，涵盖339+所高校，547+家科技公司，107+家车企，53+家政企/研究所。

**百度超级链(XuperChain)** ：百度主导发起的开源区块链项目，全球开发者数量超过50000+。目前XuperChain在GitHub star数1550+，2021年新增Commit数560+、主版本迭代3次，新增仓库数12个。在关键区块链生态技术工具上，新增由外部企业贡献XuperIDE、XuperScan(浏览器)等技术工具。2021年全年组织40+场线上直播和线下沙龙，覆盖30000+开发者，社区面对来自100多家企业和高校的爱好者进行社区官方讲师认证，完成两套课程内容并出版一部教材，与20+家双一流高校达成区块链人才培养合作计划。在2021年内，XuperChain先后通过中国信通院功能和性能测试。

**Apache ECharts** ：是一个使用JavaScript实现的开源可视化库，可以流畅的运行在PC和移动设备上，兼容当前绝大部分浏览器，底层依赖矢量图形库ZRender，提供直观、交互丰富、可高度个性化定制的数据可视化图表。作为Apache软件基金会的顶级项目，目前Apache Echarts在GitHub Star数49k+，年增10%；Contributor有185人，年增26%，其中5人在2021年成为Committer，2021年内Apache ECharts共更新发布8个版本。

**Apache Doris** ：是由百度开源并贡献给Apache软件基金会的MPP分析型数据库产品，2021年作为Apache软件基金会的孵化项目，受到DorisDB影响，延缓了毕业进程。Apache Doris分布式架构非常简洁、易于运维，可以支持10PB以上的超大数据集。Apache Doris的GitHub Star从2021年初的2k增长到3.9k，一年间增加了95%。贡献者数量从年初的130增至234，贡献者规模和活跃度都有了极大的提升。与此同时，在2021年Doris社区还迎来了5位新晋PPMC以及7位Committer加入，分别来自美团、小米、京东等多家一线互联网公司。Apache Doris分别在2021年4月和11月发布了0.14和0.15版本。

### 9.3.4 腾讯

腾讯从创立之初就和开源结下不解之缘。23年前，公司的第一款产品QQ就运行在开源Linux服务器上。近几年，腾讯的开源工作主要围绕着项目开源、生态共建、社区治理三个方向推进。项目开源上，腾讯是GitHub全球企业开源贡献榜中TOP8的企业，开源了超过160个项目，累计获得了超过41万开发者的关注和Star。与此同时，腾讯持续贡献着超过30个主流开源社区，并加入了Linux基金会、Apache基金会等十余个国际开源基金会，也是开放原子开源基金会最早的发起单位之一。近三年，连续向Linux、Apache、开放原子开源、CNCF等多个基金会等捐赠了TARS、TSeer、Angel等7个开源项目，主导LinuxKVM、JDK等9个国际开源项目。

**各技术领域的开源成绩**

在操作系统领域，腾讯持续投入超过10年，与合作伙伴经过1000多万节点大规模场景验证的云原生操作系统OpenCloudOS，成为开放原子开源基金会开源项目的一员。

在云原生领域，腾讯2021年发布了多集群管理云原生管控平台Clusternet及云原生服务发现和治理中心Polaris Mesh(北极星)2个新项目。

在大数据领域，腾讯将进一步走向全面开源，并积极贡献和反哺开源社区，即将开源全场景在线离线混部解决方案Caelus和计算领域热门方向RSS(Remote Shufﬂe Service)的新项目Firestorm。

在数据库领域，腾讯将推出针对于大规模交易场景的企业级分布式MySQL内核数据库开源项目TXSQL。

在安全领域，腾讯2021年成为中国第一家加入OpenSSF安全开源基金会的企业，将引入腾讯安全二十年的安全能力沉淀，助力简化行业的开源安全流程，为开源项目的安全性提供保障。

在云成本领域，腾讯2021年加入FinOps基金会，作为国内首家FinOps基金会顶级会员，腾讯将联合FinOps基金会，全面推进对FinOps标准和最佳实践的贡献，为企业提供云财务管理的解决方案。

在多云异构领域，2021年腾讯作为首批创始企业加入Linux基金会旗下NextArch基金会(下一代架构基金会)。

**生态共建**

在生态共建方面，腾讯将两大核心技术版块——物联网操作系统TencentOS Tiny和企业级容器编排引擎TKEStack捐赠给了开放原子开源基金会，并即将捐赠第三个云原生操作系统项目。此外，全栈机器学习平台Angel、万亿级大数据消息中间件Apache Inlong(应龙)，高性能微服务治理框架TARS,云原生边缘容器开源项目SuperEdge等也陆续捐赠进入国际顶级基金会孵化和毕业。

从2006年开始，腾讯就围绕着人才培养、联合研究、学术交流三条主线，开展腾讯高校合作犀牛鸟计划，为行业培养优秀的互联网人才。2021年，腾讯首次启动了“犀牛鸟开源人才计划”，继续与高校深入合作，帮助学生由浅入深理解开源知识，用企业真实项目反哺教学，进一步助力开源人才生态的发展。首期计划中，一共有420所国内外高校，超过3000位学生参与。累计沉淀30+门开源精品课程进入校园课堂，学生满意度达92%。

**社区治理**

2021年，腾讯云建立了开放型开源社区——腾源会。2021年5月-2022年5月，腾源会累积举办各类社区活动50+场，覆盖10万+开源实践者、开源爱好者。

通过对“全球顶级开源项目社区治理”“开源领袖实践方法论”等不同维度的话题覆盖，链接了GoCN、Java China User Group等超过10个技术社区，超过70个开源项目社区，以及超过20个的开发者社区。

2022年上半年，腾源会也推出了“WeOpen Star开源摘星计划”与“WeOpen Good开源公益计划”。截至5月，“WeOpen Star开源摘星计划”吸引了1万+开发者关注，1000+人参与，70+开源项目加入，100+所高校联动，60+位专家辅导。“WeOpen Good开源公益计划”联动了真爱梦想、NGO2.0等公益组织，吸引30+公益案例方参与，20+位专家参与辅导和开源工作支持。

**重点开源贡献**

**CloudBase Framework** ：这是一款云原生一体化部署工具，持前后端应用一键部署，能够极大降低部署门槛、提升部署效率。

**Nocalhost** ：云原生开发环境工具，通过对开发空间、集群、应用、开发者和项目管理员的重新整合，可以做到训练环境的一键部署。

**SuperEdge** ：腾讯联合社区多家厂商共同发起的该云原生边缘容器通过捐赠评定，正式成为了CNCF云原生计算基金会的沙箱项目。

此外，在当前多媒体领域的主流开源项目中，腾讯都参与了贡献，比如媒体库(FFmpeg)、流媒体服务器(SRS)、编码库(AOM)、播放器(VLC)、传输协议(WebRTC、SRT)等。同时，腾讯也参与了音视频领域的多个开放标准组织，其中在Alliance for Open Media中，腾讯是国内唯一一家Founding Member，将来还会参与到下一代开放编码标准AV2的制定中。

### 9.3.5 中兴通讯

中兴通讯是Linux基金会旗下的LFN和LF AI &Data的创始成员以及最高级别会员，拥有两大基金会的董事会、TAC等席位；也是Open Infrastructure基金会(原Open Stack基金会)重要的黄金成员，中兴通讯在该基金会贡献颇多。在Train版本中Commit总数达到5000以上，位居全球第六；Ussuri版本中LoC45万行代码，位居全球第四；是国内最早参与Ceph社区的公司之一，在已发布的K~M三个版本中，贡献位居全球前三，中国第一；在LF AI&DATA基金会孵化推理侧工具链Adlik。

中兴通讯是首批参加OPNFV、OpenDaylight开源社区的电信网络设备厂商，是电信网络向虚拟化、容器化和智能化转型、标准与开源深度融合的践行者。2015年，中兴通讯以铂金会员加入OPNFV社区，是首批通过OVP(OPNFV Veriﬁed Program)认证的厂商。2016年，中兴通讯支持中国运营商在Linux基金会发起的网络自动化管理项目ONAP前身Open-O立项，为Open-O贡献超过50%的代码。2017年成为ONAP初创会员，并担任微服务总线MSB、告警分析Holmes两个子项目的PTL。2017年，中兴通讯以铂金会员加入OpenDaylight社区，将SDN协议的代码实现贡献到社区，共发起了6个新项目，并参与了社区80%的重要项目。2017年，中兴通讯以黄金会员加入CNCF，OpenPalette产品获CNCF社区Kubernetes一致性认证，获得社区KCSP认证。2018年，中兴通讯OPNFV开放实验室通过OVP Lab认证。2019年，中兴通讯首批参与GSMA和OPNFV联合发起CNTT项目，与主流运营商和设备厂商共同制订电信网络基础设施的模型、架构和测试规范。2020年，中兴通讯支持中国运营商在Linux网络基金会发起的5G/6G电信能力平台xGVela立项，并贡献TelcoPaaS初稿。大力推动5G网络切片、网络管理自动化、网络智能化等开源与标准在5G中的结合与应用。

2021年，中兴通讯以创始单位加入智能计算产业技术创新联合体(ONIA)，与行业伙伴共同推动开源神经网络处理器指令集架构NPU-IAS生态，成为ONIA的理事单位。中兴通讯继续在国际RISC-V基金会组织中发挥创始成员(现改为铂金会员)的作用，共同讨论处理器指令的开发，提出RISC-V在HPC领域的问题。在2021年，公司以高级会员身份加入了国内最大的RISC-V开源生态组织“北京开源芯片研究院”，与国内龙头企业(互联网、设备商、芯片设计方)、高校及研究所共同研究RISC-V开源生态建设和探讨后续工作规划。2021年底，中兴通讯GoldenDB产品线联合工行、招行、银联、网联、金电、华为、金融联盟共同发起MySQL金融分支开源社区，并进入MySQL金融分支的社区管理组(PMG)和技术管理组(TMG)。

**重点开源贡献**

**Adlik** ：由中兴通讯发起孵化，是LF AI&Data中首个聚焦深度学习模型推理阶段的项目，其宗旨是使深度学习模型能够高效地运行在多种部署环境下。利用Adlik，开发者可以方便地将主流训练框架如TensorFlow、Keras、Caffe、PyTorch等训练出的模型进行编译和优化，并根据模型部署的硬件环境自动选择优化的运行时环境，从而提升模型的推理效率，减少时延和能耗。

**OpenDaylight** ：是一套以社区为主导的开源框架，旨在推动创新实施以及软件定义网络(简称SDN)透明化。作为项目核心，OpenDaylight拥有一套模块化、可插拔且极为灵活的控制器，这使其能够被部署在任何支持Java的平台之上。这款控制器中还包含一套模块合集，能够执行需要快速完成的网络任务。从2015年开始，中兴通讯深度参与OpenDaylight开源贡献，先后六次立项，实现相关SDN控制器协议和技术，并担任这些项目的PTL。

### 9.3.6 中国联通

中国联通目前参与的开源社区主要涉及云计算、白盒交换机、白盒基站、网络编排器等领域，包括OpenInfra/OpenStack基金会(担任黄金会员董事)、Linux基金会(白银会员)、OpenEuler社区等。在Linux基金会白银会员基础上，中国联通作为白银会员/高级会员参加了LFN、SODA(担任董事)、CNCF子基金会。

自研海量数据存储项目YIG和AI算能服务平台CubeAI智立方已分别被LF SODA和OpenI启智社区接受为原生项目和孵化项目。其中，YIG实现中国联通在国际主流开源社区牵头项目“零”的突破。

加入欧拉社区，并在OpenStack SIG小组担任Maintainer。2021年11月，正式发布自主知识产权操作系统CULinux(China Unicom Linux)，结合轻量级虚拟化、高性能网络、安全容器等技术，可广泛应用于服务器、边缘计算、云基础设施等多种场景，支持多样性算力，适配X86和鲲鹏、飞腾等主流国产化算力底座。

**重点开源贡献**

**YIG** ：是一款可大规模横向扩展的云存储产品，YIG基于通用标准服务器，采用存储虚拟化技术构建统一的存储资源池，对外提供标准、兼容AWS S3协议的HTTP RESTful API接口。

**CubeAI** ：自主研发的集AI模型自动化服务封装、发布、共享、部署和能力开放等功能为一体的开源AI算能服务平台。平台基于CUBE-Net微服务框架进行开发，CUBE-Net微服务框架是中国联通自主研发的开源微服务应用基础开发平台和代码脚手架工具。

### 9.3.7 小米

2017年，小米在23个开源项目中保持活跃。其中，自研项目6个，主导项目3个，参与项目14个。这些项目中，大部分推出了Committer，总的Committer人数达50人。公司全年共为各类开源社区贡献patch数超3000个。同时，不断有新的项目申请开源，其中3个新项目在2021年内通过了开源评审后对外开源。

在开源人才贡献上，新增Apache Committer11人，其他项目Committer13人。在Hadoop、Hive、RocketMQ、Dubbo、TiDB等多个有影响力的开源项目上，小米首次推出Committer，实现突破。根据Apache软件基金会发布的2021年度报告，公司员工肖翔因为其在Apache NuttX项目上的突出贡献，荣登Top5Committers名单。此外，小米开源在2021年积极参加开源生态建设。

**生态共建**

5月，通过信通院“可信开源供应链”认证，成为国内首批通过可信开源供应链认证的终端厂商之一。

8月，小米Vela成功举办了国内首次NuttX开发组研讨会，多平台直播最高观看人数3000+，整个线上交流会讨论热烈，获得了很好的效果。

9月，机器人开源社区完成了开源风险评估，正式对外开源。不久，CyberDog项目通过信通院可信开源项目认证，成为信通院可信开源社区共同体的首批会员。

9月，举办Apache Pegasus首次Meetup。Meetup共计时长5小时，线下参加的人数达75+，线上B站和Datafun直播观看人数达800+。

10月，小米升级为Apache基金会的Targeted Sliver Sponsor。

同时，小米积极将自身的开源实践经验输出到外部，《开源项目与社区案例集》第一期收录了小米 MACE、Pegasus两个项目的开源实践案例，《企业开源治理案例集》第一期收集了小米公司的开源治理案例。公司全程参与筹备的中国计算机学会开源发展委员会在2021年12月正式成立。

### 9.3.8 滴滴

2021年，滴滴成为多家开源基金会、开源组织的首批会员，并积极在社区中发挥主导作用。截至2021年末，滴滴开源共有超过81个对外开源项目，其中9个新增对外开源项目。滴滴外部开源总Star数80k+，Fork数20k+，Issue数4k+，5k+公司及组织使用了滴滴开源项目，开源项目的开发者和用户超过2万人。滴滴内部开源项目新增118个，突破500大关，年度累计4k+人参与内源，累计产生161个社群，253个技术子项。

滴滴开源还涌现出一位ASF孵化器导师、一位Apache基金会顶级项目Pulsar的Committer。滴滴开源的消息与函数团队为Apache Pulsar项目持续贡献了49个PR，其中33个完成合并； 系统软件团队向Linux内核/OVS等社区贡献10个patch，参与多个patch的Review并给出改进建议；KV团队向RocksDB社区贡献4个PR完成合并；DT-计算平台为HDFS、Iceberg、ClickHouse、StarRocks、Pulsar、BookKeeper的等项目贡献56个patch。

**生态共建**

2021年3月，由中国开源软件推进联盟副秘书长、北京大学荆琦教授牵头组织，滴滴和北大软微学院联合开设的“开源软件开发基础及实践”课程通过了北京大学研究生院的新课申请，正式面向北大软微学院全体研究生开放授课。

2021年11月，滴滴开源参与Linux基金会旗下NextArch Foundation下一代架构基金会的筹建工作，成为首批共建和支持单位。同时齐楠作为企业代表成为TOC成员，参与探讨和制定基金会的发展路线工作。

2022年1月，Dokit、DELTA、LogicFlow、KnowStreaming等四个滴滴开源项目通过中国信通院评审，成为《可信开源社区》共同体成员。

**重点开源贡献**

**DoKit** ：目前在GitHub上的Star数已经突破18000，已累计14000+终端App接入使用。

**LogicFlow** ：2021年在npm发布了90+小版本，并于2021年12月31日发布1.0版本。目前已有较多公司在实际项目中接入使用，LogicFlow平均npm周下载量40k+、GitHub Star 2k、收到GitHub Issue 200+。

**Know Streaming** ：Know Streaming基于Apache 2.0协议进行分发和开源，未来考虑捐赠给国内开源组织，为中间件类基础软件运维管控做一点自己的贡献。

### 9.3.9 微众银行

自2014年成立开始，微众银行就全面使用开源技术。截至2021年底，微众银行已有33个对外开源项目，超过230个代码仓，涵盖AI、区块链、云计算、大数据、大前端等多个技术领域。Star总数超过27,000个，Fork近10,000个。

2021年2月，EventMesh成为国际顶级开源组织Apache软件基金会的孵化项目，这是国内金融行业首个进入ASF孵化器的开源项目；8月，Linkis项目成功进入ASF孵化器。

在AI领域，FATE作为微众银行人工智能团队发起的全球首个联邦学习工业级开源框架，吸引了腾讯、Vmware、银联、工行、中行、农行、建信金科、光大科技等10余家外部企业加入到开源TSC(技 术指导委员会)中，形成TSC Board和TSC Maintainer的组织架构，共同参与项目的发展和社区的建设。截至到2021年底，社区用户数超过3500人，社区企业数超过1000家，高潜客户数400个以上。

在区块链领域，微众银行牵头并且作为核心贡献者的FISCO BCOS开源生态圈已汇聚超3000家企业及机构、70000余名个人成员。FISCO BCOS已成功支持政务、金融、农业、公益、文娱、供应链、物联网等多个行业的数百个区块链应用场景落地，FISCO BCOS开源社区收集到的标杆应用超过200个。2021年12月，发布了FISCO BCOS V3.0版本，从架构、算法、产品以及安全可控和隐私计算协同等多方位进行全面升级。

在大数据领域，公司开源的WeDataSphere大数据开发平台通过可插拔、组件化的架构设计覆盖数据应用开发管理全流程，包含Linkis、DataSphere Studio、Schedulis、Qualitis等多个开源的组件系统。截至2021年7月，Linkis已拥有了700多家试验企业和超过1000个沙盒试验用户，涉及金融、电信、制造、互联网等多个行业。

### 9.3.10 浪潮软件

浪潮产品当前使用的国际开源软件超过900余个，涉及40余种开源协议，参与200余个开源项目的社区贡献，覆盖云计算基础设施、云原生基础设施、工业互联网、分布式数据库、区块链等多个技术领域。

公司先后加入OpenStack、Linux、Apache、SPEC、TPC等国际权威组织，以及全球三大开放计算标准组织，并成为ODCC供应商会员、OCP铂金会员和OPEN19首批成员。浪潮是木兰开源社区首批贡献者和社区建设的践行者，同时作为创始会员共同筹建了中国首个、也是目前唯一一个以开源为主题的基金会——OpenAtom开放原子开源基金会，作为副理事长单位参与到社区建设中。

推动近百人参与OpenStack社区贡献。在社区即将发布的Yoga版本中，代码提交量(Commit)、完成蓝图数量(Completed Blueprint)、补丁集数量(Patch Set)、贡献代码行数(LOC)等方面均为中国第一。

公司向OpenStack国际开源社区贡献首个智能运维领域开源项目VENUS并完成孵化，顺利成为官方项目；云海OS团队聚焦Nova、Cinder、Cyborg、Manila等核心项目，实现对异构加速器设备虚拟机的支持并完善虚拟机重建和疏散、搁置和取消搁置等功能；新增任意时间节点的卷快照回滚、Inspur SSD、FPGA设备驱动、文件存储回收站等功能，并在智能加速设备管理Cyborg、可视化日志管理Venus、云数融合Sahara和高可用管理Masakari等主流项目新增PTL(开源项目负责人)4名，Core Reviewer十数名，社区全球贡献排名全球前五，国内第一。

**社区贡献**

**CNCF社区** ：自2017年开始，在声明式集群管理、多容器运行时、多容器网络、多容器存储、镜像加速、网络加速、主备容灾等方面重点技术研发，并持续回馈社区，累计提交贡献4000+。基于CNCFCKAD认证体系和Kubernetes项目的实践经验，已开展云原生系列课程培训20余次。通过CNCF Kubernetes X86和ARM双一致性认证，为社区贡献首个MIPS架构Kubernetes一致性测试方案。

**OpenAtom社区** ：围绕低代码、工业互联网、云原生等技术领域，参与ApereCAS Server、Helm、Bitnami、SEATA等开源项目贡献。已将UBML低代码平台项目(工业互联网方向)和云溪数据库(云原生分布式数据库方向)两个项目捐赠给开放原子开源基金会，成为基金会旗下的孵化项目。

**木兰社区** ：贡献云操作系统控制台OpenSkyline项目到木兰开源社区，通过TOC评审顺利进入木兰开源社区开源项目孵化池。基于Gitee、GitHub、Trusite多库托管，实现各平台项目代码相互备份，成功发布第一个正式版本。

2021年，公司正式发布“源1.0”开源开放计划，模型参数规模为2457亿，训练采用的中文数据集达5000GB，相比GPT-3模型的1750亿参数量和570GB训练数据集，参数规模领先40%。

**重点开源贡献**

**UBML** ：定位于工业互联网平台架构中的aPaaS层。具有微内核可扩展开放架构、全栈业务建模、开发语言无关性、模型工程化、模型全生命周期管理、同时支持解析型+生成型的Hybrid模式等特点。

**云溪数据库** ：自主研发的云原生分布式数据库，采用分布式架构设计开发。提供数据库原生自动部署、自动备份、自动容灾、数据恢复、监控等全套解决方案，可支撑单表过亿的海量数据事务交易 场景。

### 9.3.11 京东

京东对外开源了前端、云计算、人工智能、区块链、联邦学习等一系列项目。2018年将分布式文件系统和对象存储系统ChubaoFS项目捐献给CNCF基金会，并于2020年进入沙箱。

京东紧密保持与国内外开源基金会与组织的联动，不仅是CNCF会员、OpenEuler会员，还加入了中国信通院云计算标准和开源推进委员会、科技制造开源技术应用社区，并且也是开放原子开源基金会的初始会员之一。

### 9.3.12 字节跳动

字节跳动积极投入开源社区建设。从2015年Rcproxy项目开始，字节跳动陆续对外开放多个经过内部业务验证的开源项目，包括现代Web开发框架Modern.js、微服务中间件CloudWeGo、高性能分布式训练框架BytePS、联邦学习平台Fedlearner、训练加速引擎LightSeq、Flutter应用内调试工具UME等。

目前，字节跳动已经对外开源五十多个项目，分布应用在前端、客户端、后端、AI/算法等领域。

## 9.4 中国原生开源企业加速涌现

### 9.4.1 麒麟软件

2014年，麒麟软件(前身为中标软件)成为开源社核心初创成员，2016年成为Linux基金会正式成员，2019年在开源OpenStack正式项目中获得1个项目的领导者(PTL)席位，2021年成为可信开源社区共同体正式成员。

社区贡献上，麒麟软件是Linux、Ubuntu、Debian、Ubuntu Kylin、UKUI、OpenStack、OpenEuler、GNOME、Unity、Ceph、Ovirt等知名开源组织和项目的重要贡献者与维护者。由公司发起的开源项目UbuntuKylin开源桌面操作系统累计安装量(仅官网下载统计)超3800万、UKUI桌面环境进入多数主流Linux发行版软件仓库。

公司热衷于开源布道，为埃塞俄比亚、加纳、赞比亚等7个国家提供开源操作系统培训服务，并累计在全球30多个城市的50多所大学里举行了版本发布会、麒麟杯软件大赛、开发者大会、Linux应用沙龙、生态软件测试、KMRE体验等超过100场的线下活动，让开源操作系统真正走进多所高校的教学课堂和课程实践，培养出Linux人才数万人。

**重点开源项目**

**UKUI** ：是一款基于Linux系统可插入框架的轻量级桌面环境。基于Qt进行开发，用于浏览、搜索和管理计算机。截至2022年2月，UKUI项目Issue超过4600，Pull Request超过3000，Commit超过17100，Contributor共246人。

**优麒麟(Ubuntu Kylin)** ：是一款通用桌面电脑操作系统，自2013年以来已发行19个正式版本，全球累计安装量超3800万次，社区爱好者数十万，社区贡献者数百位。截至2022年2月，Ubuntu Kylin项目Issue超过780，Pull Request超过650，Commit超过5290，现有5个SIG。

**社区贡献**

**Kernel.org社区** ：麒麟软件向Linux Kernel所做贡献覆盖Ceph、xor、raid、io_uring、net等。在全球参与内核贡献的近900家企业中，贡献排名居244位，在国内贡献企业中排名第12位，累计Submit(Patch)104个。

**OpenStack社区** ：截至2022年2月，麒麟软件向OpenStack社区累计Submit(Patch)5500+，修复Bug 1600+，完成蓝图40+，贡献代码10万行。

**openEuler社区** ：公司共有155人直接参与openEuler社区，其中2人为TC，24人为Maintainer。截至2022年2月，累计提交Issue 1300+，Pull Request 2000+，维护项目300+，参与代码类项目50+，发起6个SIG，在5个SIG中担任Maintainer。

### 9.4.2 统信软件

统信软件基于Linux内核自主研发并开源了DDE桌面环境以及系列应用软件，已被主流Linux发行版所采纳。在国际主流社区(Ubuntu、Debian、CentOS等)贡献组件数量超过70多个。参与上游Linux Foundation内核社区开源贡献，在操作系统核心组件如kernel、gcc、binutils、glibc、cmake、elfutils、libtool、clang、boost、gdb等领域，统信软件适配集成补丁超过5000个。自研并反馈上游社区补丁超过500个，其中被上游社区采纳数量超过400个。

作为全球Linux最重要的发行版之一，统信操作系统社区版deepin全球累计下载量超8000万次，全球社区用户超过200万。自加入Qt社区，2020年代码贡献排名第五；2021年代码贡献度排名第三。

**社区贡献**

**统信开源社区(deepin)** ：用户遍布全球100多个国家与地区，累计发布版本40余次，支持语言34种，累计下载量超过8000万次，全球社区用户超过200万，提供开源代码超过600万行。拥有6个海外社区，在40多个国家拥有130多个镜像站点，可为中国操作系统提供国际开源社区支撑。

**openEuler** ：统信软件服务器研发负责人担任openEuler社区TC委员，6个SIG组maintainer由统信软件研发专家担任，累计申报TC议题9次，提交Issue100+，提交PR239个，参与社区SIG例会113次，积极活跃于社区29个SIG组(例如：Kernel、虚拟化、容器、Release、QA等重要SIG)。已为社区提交Pull Request 900+，Issue 900+，举办SIG Meeting 100+。贡献自主研发的桌面项目58个，在openEuler 21.09创新版本完成DDE大版本迭代一次，并引入了自研的桌面影音软件。

**OpenAnolis** ：统信软件是OpenAnolis(龙蜥)社区理事单位，在OpenAnolis社区的贡献或参与情况包括：提供DDE桌面及其相关的系列桌面应用；提供arm编译构造与集成环境，并进行部分社区基础设施维护；提供社区版本ISO集成构造技术支持，参与社区的版本构建与发布；构建社区版本的容器镜像并提供容器的构造文档；参与社区版本的测试与测试报告输出；参与社区代码提交审核等。截至2021年7月底，完成社区代码仓库同步3600+，koji提交3900+，Commit提交220+，Bug提交30+，Bug修复70+，以及部分社区技术文档编写；参与维护的社区SIG组包括Cloud Kernel、DDE、跟踪诊断技术、高性能存储、全栈国密、Java语言与虚拟机、LoongArch、Distro、基础设施、QA；轮值参与社区社群内开源用户问题反馈沟通与技术交流。

**上游贡献(Ubuntu、Debian、CentOS等)** ：自主研发开源DDE桌面环境及系列应用软件，已被主流Linux发行版所采纳。在国际主流社区(Ubuntu、Debian、CentOS等)贡献组件数量超过70多个。在核心组件如Kernel、Gcc、Binutils、Glibc、Cmake、Elfutils、Libtool、Clang、Boost、Gdb等领域，统信操作系统适配集成补丁超过5000个。


### 9.4.3 平凯星辰

PingCAP(平凯星辰)成立于2015年，是一家企业级开源分布式数据库厂商，分布式关系型数据库TiDB为该企业创立。TiDB及其生态项目累计超过1700位开源贡献者，覆盖41个国家和地区，汇聚了15000+TiDB资深用户。社区线上论坛asktug.com积累13900+个问题帖，95%的问题都得到了解决，累计总回复数89800+。

TiKV亦由PingCAP发起和主导，是CNCF首个基于Rust的KVDatabase项目，也是第12个从CNCF毕业的项目；Chaos Mesh是一个云原生混沌工程平台，目前还在CNCF的沙箱中孵化。

**重点开源贡献**

**TUG(TiDB User Group)** ：汇聚了全球数据库、大数据技术从业者，是一个独立、自治、不以盈利为目的的社区组织。

**TiDB** ：在GitHub上已总计获得超过30.6k颗星，累计超过1200位开源贡献者，目前项目已经合并的Pull Request数21349个，已经解决的Issue数8551个。TiDB项目来自PingCAP以外的社区贡献者(Contributor)占比70%以上。

**TiKV** ：在GitHub上已总计获得超过10.8k颗星，累计超过470+位开源贡献者，项目已经合并的Pull Request数8485个，已经解决的Issue数2556个。TiKV项目主要开发者来自PingCAP、知乎、京东云、一点资讯等企业，来自PingCAP以外的社区贡献者(Contributor)占比65%以上。

**Chaos Mesh** ：在GitHub上已总计获得超过4.6k颗星，累计超过150+位开源贡献者，项目已经合并的PullRequest数1847个，已经解决的Issue数837个。

**开源社区活动**

**Infra Meetup** ：自2016年3月开始，TiDB社区定期在周末举办Infra Meetup，邀请业内专家与大家深度探讨基础架构领域的前瞻性技术思考与经验，目前已在北京、上海、广州、成都、杭州、深圳、西安等地成功举办145期活动。

**Paper reading** ：是TiDB社区的小伙伴分享研读数据库、分布式等相关领域的论文心得的活动。

**TUG企业行** ：TUG企业行系列活动定期走入互联网顶级头部企业。

**TiDB Hackathon** ：参赛队伍需在规定时间(48小时)内围绕整个TiDB生态做出一个完整的作品，并由评审最终评选出获奖者。目前已成功在北京、上海、广州举办，超过50支队伍参与比赛。

**PingCAP DevCon** ：是由PingCAP举办的年度数据技术盛会，大会已连续举办三年。

**TechDay** ：TiDB TechDay是以城市为主体的技术分享活动，社区开发者共同学习、分享TiDB技术内核，目前已成功在北京、上海、深圳、成都、武汉、杭州举办，覆盖人数2000+。

**开源社区建设**

**TiBigData** ：由知乎发起的incubator项目TiBigData，旨在解决企业大数据场景中各项技术栈对接TiDB的整合问题。目前已提供TiDB与Flink、Presto的整合能力，并已应用在知乎的数据集成平台和OLAP分析场景中。

**Weir** ：Weir是伴鱼发起的面向分布式数据库的数据库中间件平台，现已完成MySQL协议支持、多租户管理、连接池、后端负载均衡、配置热加载、平台化管理等功能，在伴鱼内部开始推进业务接入。

**TiDB for PostgreSQL** ：项目由神州数码发起，旨在提供TiDB对PostgreSQL的兼容性，同时保留了TiDB的高可用性、弹性和可扩展性。允许用户将现有的PostgreSQL客户端连接到TiDB，并使用PostgreSQL特有的语法。

**ServerlessDB for HTAP** ：项目最终目标是要把云数据库服务变成黑盒子，让应用开发者只需要专注于业务如何转化成SQL，用户再也不用操心数据量、业务负载、SQL类型是AP还是TP等这些和业务不相关的事情。

**zh.md** ：zh.md实现了一套中文文档分析与检测工具，基于AST(抽象语法树)和分词，系统地对文档进行扫描与诊断，评估文档质量并对其进行优化和修复，并且基于文档分析结果，使用统计学/NLP等工具，辅助作者写出符合风格规范的文档。

**公司融资情况**

![请添加图片描述](https://img-blog.csdnimg.cn/857c5a781b2145c085747e160dcef331.jpeg)
<span style="font-size:10px;color:#707070;text-align:left !important;display: block;line-height:1.5em;"><br>表31 平凯星辰融资情况</span>	　

### 9.4.4 易捷行云

易捷行云EasyStack(北京易捷思达科技发展有限公司)成立于2014年，是中立的企业级云计算产品与服务提供商。易捷行云EasyStack深耕开源生态产品化，率先实践开源基础设施标准LOKI(Linux OpenStack Kubernetes Infrastructure)。在Linux方面，公司是Linux基金会会员、开放原子开源基金会openEuler社区成员、龙蜥社区会员；在OpenStack方面，公司是OIF黄金会员和创始成员，连续两年成为拥有OIF黄金会员董事和个人独立董事的“双董事”席位的唯一中国企业；在Kubernetes方面，公司是CNCF和OCI容器基金会会员；在基础设施方面，公司是Ceph基金会创始会员。

易捷行云EasyStack积极参与开源社区并贡献核心代码，多次在OpenStack、Ceph、Kubernetes核心代码贡献中名列全球TOP10。此外，公司是开放原子开源基金会捐赠人，参与发起“科创中国”开源创新联合体并成为联合体理事单位。

**开源社区建设**

易捷行云EasyStack鼓励全员参与工作相关的各类开源社区，包括OpenStack、Kubernetes、Ceph、openEuler、龙蜥等社区，在多个社区获取重要的角色，包括Kubernetes、OpenStack等多个项目的核心评审员。

**OpenStack** ：在Nova、Cinder、Neutron、Keystone等核心项目贡献排名Top 5，总计贡献Commits数318，修复Bug数8个，贡献代码量12000+行，工作超过1000人天，KataContianer核心贡献者1人，主导国内、东南亚等区域活动，提升社区影响力。

**Ceph** ：Ceph社区贡献次数119次，代码量6000+行，核心Committer 1名，作为赞助商协助推动开源社区透明性建设，推进社区规划及财务公示，官方网站关注运营模型介绍等信息。

**CNCF** ：CNCF社区投入Kubernetes、containerd、etcd、kube_OVN等多个项目，其中社区多个版本国内贡献TOP10，贡献核心需求10+，修复Bug数十个，是社区赞助商之一。

**公司融资情况**

![请添加图片描述](https://img-blog.csdnimg.cn/9f3fef6772dd4c0a8df5cbc744565c2b.jpeg)
<span style="font-size:10px;color:#707070;text-align:left !important;display: block;line-height:1.5em;"><br>表32 易捷行云融资情况</span>


### 9.4.5 涛思数据

涛思数据采用AGPL许可证，已将TDengine的内核(存储、计算引擎和集群)全部在GitHub开源。2021年，TDengine仍然按照两周一个版本的频率迭代，同时改变了发布规则，同步推进Beta版本和稳定版本。合并了4607个Pull Request，正在运行的测试用例接近1800个，软件代码行数共计104万行。

2021年，TDengine共发布了大大小小30余个新功能，重点包括：降低企业迁移成本的独立程序taosAdapter；基于Grafana的TDengine零依赖监控解决方案TDinsight；以及纳秒时间精度、浮点数有损压缩、原生接口写入、嵌套查询、无模式(Schemaless)写入等等。截至2022年2月底，TDengine已经在GitHub上获得17.8k颗星，还多次在GitHub全球趋势排行榜上排名第一。

**公司融资情况**

![请添加图片描述](https://img-blog.csdnimg.cn/b967ac303a4f4b1ba27d00bf5aaede9b.jpeg)
<span style="font-size:10px;color:#707070;text-align:left !important;display: block;line-height:1.5em;"><br>表33 涛思数据融资情况</span>

### 9.4.6 白鲸开源

目前，白鲸开源稳定运营着两个开源项目，分别为大数据工作流调度平台Apache Dolphin Scheduler和大数据集成平台SeaTunnel。

其中，基于Apache开源社区理念打造的Apache Dolphin Scheduler，已累计在600多家公司生产环境中作为核心调度系统，贡献者超过310人。

2021年12月，SeaTunnel正式成为Apache孵化器项目，这也是Apache基金会中第一个诞生自中国的数据集成平台项目。2017年对外开源后，SeaTunnel已经发布了31个版本，贡献者超过50人。

### 9.4.7 思斐软件

北京思斐软件技术有限公司(SphereEx)于2021年4月，由Apache顶级开源项目ShardingSphere核心团队创立。2021年5月获得数百万美元天使投资，2022年1月获得近千万美元Pre-A轮融资。

SphereEx曾在Google Summer of Code、西雅图创业协会、Stack Overflow等多个组织分享开源技术与创业经验。累计在全球参与包括PGConf.Asia、COSCon、ApacheCon、OpenSource Day、Grace Hopper Celebration等在内的50多次海内外线上、线下活动。

**重点开源贡献**

**ShardingSphere** ，是一套开源的分布式数据库中间件解决方案组成的生态圈，可以将任何的数据库转换为分布式数据库，并通过分片、弹性扩展、加密等功能对其进行增强。截止目前，ShardingSphere项目被全球近200家企业登记使用，在GitHub上获得超过15.4k颗星，合并Issue超过6000，PullRequest超过9200，Contributor超过300，累计贡献代码超过42万行。

ShardingSphere于2018年正式进入Apache基金会孵化器，2019年进入CNCF全景图，2020年成为Apache顶级项目。2021年度Apache基金会年度报告中，ShardingSphere代码提交数量位列前十。

## 9.5 国际机构、国际企业对中国开源的贡献

通过本章前文所述，我们可以看到中国在开源贡献上令人欣喜的进展，短时间内从使用开源到积极贡献。但在目前的开源贡献者索引网站中，活跃贡献者排名前十依然是国际企业。因而，国际机构和企业的开源实践，以及对中国的开源贡献将进一步推动中国开源的发展。

为此，我们以Apache基金会、Linux基金会、IBM、Intel、微软、红帽等机构和企业为例，介绍国际通行的开源之道，以及对中国开源的贡献，希望可以对中国的开源发展有所启发。

### 9.5.1 Apache对中国开源的贡献

2012年之前，国内与ASF(Apache Software Foundation，简称“ASF”)接触的公司主要集中在外企，例如Intel中国研发中心、IBM中国研究院、eBay中国等。但在2012年之后，华为、阿里巴巴、百度、京东、腾讯等公司开始陆续将项目捐赠给ASF，在ASF的孵化下，多个项目成为顶级项目。

伴随着越来越多来自于中国的项目进入到ASF，中国的Committer数量也在不断增加。如图35所示，在2010之前，中国开发者参与度并不高。自2014年开始，中国Committer数量逐年递增，直至今日，中国Committer数量占到新增Committer一半左右的比例。

![请添加图片描述](https://img-blog.csdnimg.cn/c6a49ae547ff4a61a9f09b8ac1bb9018.png)
<span style="font-size:10px;color:#707070;text-align:left !important;display: block;line-height:1.5em;"><br>图35 Apache Committer总人数和中国人数</span>

图36展示了2014年之后源自中国Apache孵化项目与所有进入到ASF的孵化项目对比，可以看到2021 年之后来自于中国的孵化项目占比越来越大。

![请添加图片描述](https://img-blog.csdnimg.cn/e0c0b842a56646bda2e9f55a55a23719.png)
<span style="font-size:10px;color:#707070;text-align:left !important;display: block;line-height:1.5em;"><br>图36：进入ASF孵化器项目数和源自中国项目数</span>

**Apache在中国举办的ASF相关会务活动**

* 2008年12月
   
    "Apache Beijing 2008 Meetup”在北京Intel研发中心举办，作为第一次ASF官方活动，拉开在中国传播布道的活动序幕。

* 2009年12月 

    “Apache RoadShow Asia 2009”会议在北京Intel研发中心举行，会上介绍了Apache Hadoop项目，以及与开源相关的创业与投资。

* 2010年7月 

    在复旦大学张江校区举办的“Apache RoadShow Asia 2010”会议，两天活动吸引了300多位Apache项目的粉丝参会。

* 2015年10月

    “ Apache RoadShow China 2015 北京”活动，时隔五年，开源社将Apache路演引入中国，通过“现场+直播”的方式吸引几千人参与。

* 2018年10月 

    “Apache Committer Meetup上海”活动，聚集了Apache孵化项目的Committer与ASF官员进行深度交流。

* 2020年8月 

    “ALC Beijing Meetup”，本次沙龙是ALC Beijing成立以来首次线下活动，主要是分享开源开发经验、探讨如何让开源项目更加茁壮成长，以及分享ASF管理和运作开源项目的成功之道。

* 2020年10月 

    “COSCon China 2020&Apache RoadShow China”进行了大型五地的线上、线下混合会议。

* 2021年8月

    “ApacheCon Asia 2021”召开，  Apache亚洲大会时隔15年之后第一次以线上会议的方式回归亚洲。在为期三天的会议中，以13个主题、150多个议题，全方位介绍ASF 40+相关项目，吸引了近30万观众观看。

* 2020年2月&2021年12月

    2020年2月，ALC-Beijing在遵照Apache软件基金会Local Community原则下，在Apache软件基金会申请成立，ALC-Beijing是面向北京的开源社区组织。2021年12月，ALC-Shenzhen成立，吸引到深圳本地ASF项目开发人员40+。目前，ALC Beijing&ALC-Shenzhen运作日益规范，每两周的线上会议加上不定期的线下会议，让社区成员交流和合作更加充分。

### 9.5.2 Linux基金会（包括CNCF）对中国开源的贡献

Linux基金会(The Linux Foundation，简称LF)提供了一个中立、可信的中心供全世界的开发人员和企业共同开发、管理和扩展开源项目。目前,中国在开源代码贡献和项目贡献方面都在不断加速，已经成为非常重要的参与角色。以CNCF为例，通过CNCF基金会和中国开源社区的努力,源自中国的代码贡献率已跃居世界第二，来自中国的开源项目超过30个，约占所有CNCF项目的25%。

在过去20年中，Linux基金会已经从支持单个项目(Linux内核)扩展到许多不同的项目社区。超过2300名成员和数十万开发人员参与了一些最重要和最活跃的开源项目，在云、安全、区块链和Web等跨行业技术领域进行合作。

2021年，Linux基金会在其支持的数百个开放技术社区中的贡献和参与度都在持续增长。其中，中国区成员的增长更是有目共睹，单是CNCF中国区成员的增长就达到了80%。

随着对专业人员需求的增加，供应商中立的培训和认证变得越来越重要。在中国，已有超过5500人被认证为Kubernetes认证管理员。2021年，Linux基金会向全球包括中国在内的个人颁发了免费培训和认证奖学金，数百人通过与非盈利组织的合作获得了奖励。

除了以上贡献，Linux基金会也一直通过各类活动及合作为中国开源发展带来助力。

* 2007年，Linux基金会组织欧美资深开源开发者来北京支持COPU召开的“Linux开发者国际会议”，与国内开发者展开深入交流。

* 2008年，作为主要助力之一，Linux基金会助力COPU无偿聘任数十名国际开源领袖、开源大师为智囊团高级顾问，从而建立了中国的开源高地(也是创新高地、科技高地和人才高地)。

* 2017年，Linux基金会成立一批旗下跨界的基金会(如云原生、区块链、人工智能等)并建立孵化器，为中国和全球培养人才与发展技术作出贡献。

* Linux基金会参加COPU每年一度“开源中国开源世界高峰论坛”，是圆桌会议的主力团队，主要讨论国际开源技术的发展前沿、国内外开源发展中的问题和解决方案，包括讨论开源人才培养、生态系统建设以及开源的国际合作问题。

此外，Linux基金会为不同的生态推出了许多新的基金会，越来越多的中国企业加入合作，例如RISC-V成员在2021年上半年增加一倍多，其中很多是来自中国的成员。LF AI & DATA、LF Networking、O3DF、OpenSSF、CNCF等基金会的董事会成员也有越来越多的中国企业加入，另像NextArch等由中国企业发起的开源基金会正在全球蓬勃发展。毫无疑问，中国将继续参与全球开源并发挥重要的影响力,和全世界共同构建开源产业生态。

未来,Linux基金会和中国团队将继续推动企业和社区参与全球开源合作，培养更多开源人才。

### 9.5.3 IBM对中国开源的贡献

IBM是最早的开源拥护者之一，自20世纪90年代初期开始支持Linux、Apache和Eclipse等有影响力的社区，推动开放许可、开放治理和开放标准。IBM参与的开源项目覆盖了Linux内核、开发框架、人工智能、云计算、数据科学、区块链、IoT、量子计算、芯片等技术领域(https://www.ibm.com/opensource/) 。截至目前，有超过5000名IBM员工(大量在中国)活跃在各类开源项目中，在GitHub的IBM组织里有2300余个IBM贡献的代码库(其中许多在中国开发)。与此同时，IBM帮助中国企业建立开源治理机制，发展开源文化，并积极参与开源。
IBM定期维护的“开源之道(https://developer.ibm.com/articles/cl-open-architecture-update)” ,包括IBM选择开源项目的原则并且提倡开放治理，可以帮助中国企业在参与开源时从海量的项目中进行挑选，同时通过以身作则，避免大企业垄断开源生态。

IBM一直积极为开源相关的政策标准等建言献策，比如对2022年3月征求意见的《软件供应链安全保障基本要求》的行业标准草案，以及对国家标准草案《软件供应链安全要求》提供意见，并积极为《专利审查指南》的多次修订建言。

与此同时，IBM在中国积极推广开源技术，举办了Hyperledger、Knative、Kubeflow、Istio、LoopBack、Serverless应用案例赏析等系列开源技术深度分享。

“代码集结号(Call for Code)”是IBM联合联合国人权组织等机构发起的一项全球倡议，旨在号召开发者为世界上最大的挑战创造技术解决方案，这个倡议在发起时即被IBM引入中国。2021年，大中华赛区有超过2000个团队或个人参与，在4个中国城市开展线下活动。

为便于中国开发者参与，IBM推动成立了许多开源项目的中国工作组。例如，IBM中国在2020年成立Open Horizon中国兴趣小组。2016年，IBM推动Hyperledger社区成立超级账本中国技术工作组(TWGC)，来自IBM的开源贡献者多次担任TWGC的组长。

“开放主机(OMP)”是在Linux基金会下的项目,由IBM贡献并于2015年与其他16家企业和大学共同创建。自2016年起，全球(含中国)各地优秀的学生被选拔参与该项目。截至2022年，有60+学生(含中国)参与了100+(含中国)个项目，很多学生在完成实习之后都成为了主机领域的优秀员工。

此外，IBM还为中国高校师生打造结合开源技术的前沿技术课程，如数据科学、区块链、云计算、设计思维等。利用相关的开源和IBM技术，助力老师进行课程升级和教学改革，帮助学生掌握开源技术并积累参与开源社区的经验。

IBM的开源服务和基于开源的云计算、自动化、人工智能、区块链及数据科学等产品于2021年收入中国信通院开源供应商目录第一和第二批(http://www.caict.ac.cn/xwdt/ynxw/202109/t20210926_390439.htm) 。 与此同时，IBM还跟中国信通院共同协作推广中国开源服务标准，并成为白金级合作伙伴。

为应对开源软件没有商业保证和服务级别协议的挑战，IBM在中国建设了一支有90余名工程师组成的开源专家队伍，可以对三十余种最常见的主流开源软件提供现场专家支持。其他主流开源软件也可以得到全球多个开源技术支持中心专家的迅速响应和支持。

**IBM对中国开源的建议**

主流开源项目和开源社区都具有服务全球用户、接受全球贡献、提倡开放治理、发言权和贡献度相匹配，以及避免个别企业试图主导或控制的特点。

在此基础上，中国的开源活动可更具全球视野，积极参与国际主流开源社区和项目，了解其发展方向并施加影响，同时在此过程中培养人才，树立中国在国际开源领域的形象，进而吸引全球开源贡献者参与中国的开源社区和项目，创造并扩大商业价值之外的附加值。

此外，需要服务水平协议和商业保证的企业用户，可以参照中国人民银行等5部委颁布的开源政策，向供应商采购基于开源的商业产品。

### 9.5.4 Intel对中国开源的贡献

Intel一直注重对开源软件的投入，开源项目涵盖了Linux内核、虚拟化、云计算、网络与存储、Android、Web和固件等技术领域，涉及的国际开源项目多以中国为主要研发基地，许多中国工程师成为了这些项目的重要维护者和技术领导者。

2006年，Intel倡导并和清华大学、AKA社区合作发起了中国Linux内核开发者大会。大会逐渐发展成为中国顶级开源技术论坛，同时也挖掘了一批中国内核顶级专家。此外，Intel积极支持并赞助中国开源操作系统年会。2012年，Intel、新浪、中标软件以及上海交通大学联合成立了“中国开源云联盟”，整合中国公司的研发资源，持续推动中国开源云事业的发展。在联盟指导下，Intel于2015年联合华为发起了一系列开源黑客松活动，在2020年与业界伙伴倡导合作了云计算基础架构开发者大会，为中国开源软件的活跃和技术合作贡献了力量。

Intel在系统软件领域与业界建立了长期广泛的合作关系，积极参与中国开源操作系统社区建设。目前Intel已加入开放原子开源基金会旗下的三大主要开源系统软件社区：在龙蜥社区，Intel是创始理事会成员和技术委员会成员，在社区创建并管理了英特尔架构SIG；在欧拉社区，Intel创建了类似的SIG，不断把Intel新平台和特性加入到欧拉代码仓；在OpenCloudOS社区，Intel也是创始成员和理事会成员，并当选社区副理事长单位。Intel正在把长期在开源技术领域的积累和国际开源社区的经验贡献到中国社区。

从2006年起，Intel与上海交通大学合作推出了Linux内核课程，由Intel工程师撰写课程内容并授课三年，后与交大教师联合授课。以此为基础，Intel与高教部合作，在2007年和2008年暑期于北京大学举办了面向全国多所高校的Linux内核教育的师资培训，总共培训120人次，为全国高校的Linux课程建设打下了坚实的师资基础。

在系统固件领域，Intel早在2005年就将自研的可扩展固件接口EFI贡献给业界。该接口后来演变为新一代固件BIOS的标准UEFI。此后，Intel中国的技术团队开发、贡献了EFI的参考实现TianoCore并将其开源，由TianoCore逐步演化，发展出的EDK II固件，被业界纷纷采用以取代古老的BIOS。为了把最新的系统固件技术带入中国，Intel中国的工程师们还举办了多届技术培训班，帮助中国厂商适应和迁移到基于UEFI的固件。

在Web领域，Intel积极推动开放Web技术与中国前端开发技术的融合。作为W3C中文兴趣小组的主席成员，Intel大力支持中国小程序生态在W3C的框架下的标准化工作，实现各种小程序之间以及Web应用之间的互联互通。Intel还邀请了领先的中国企业共同建设基础支撑技术社区。经过多年发展，这些社区现在已经由中国的贡献者所主导，并在中国产业界得到了广泛的应用。

在网络及存储优化领域，Intel是DPDK和SPDK等相关社区的主要贡献者、推动者和布道者。Intel协调组织了DPDK中国峰会和SPDK中国技术峰会，与中国主要云厂商及电信厂商建立了密切的合作关系，使DPDK和SPDK成为它们构建基础架构设施的必备组件。同时，Intel和高校密切合作，积极推动网络创新技术的发展及人才的培养。

综上所述，Intel为中国开源产业界培养了大批顶尖技术专家，为中国开源事业走向世界，在世界发挥中国影响力做出了卓有成效的贡献，起到了积极且关键的作用。

### 9.5.5 微软对中国开源的贡献

微软对于开源领域的投入最早可以追溯至2001年Shared Source软件的开源，自此，微软开始在开源领域不断进行贡献，与开源社区共同成长，并积极参与到开源软件的贡献当中，为开源软件提供支持和帮助。每年，在微软公司内部有超过15000名工程师在GitHub上参与社区项目贡献。

在推动中国开源发展进程中，微软也发挥了重要的作用：2014年，微软开放技术作为核心初创成员，联合中国支持开源的企业、社区及个人开发者共同成立了开源社；同年，微软开源.NET并将其捐给.NET基金会，帮助开发者可以在更多场景中使用.NET来开发应用程序，Linux、macOS等平台得以运行.NET应用程序；2020年，开源社联合疫战2020公益小组，基于微软(亚洲)互联网工程院商用人工智能团队的智能对话平台，打造了智能问答机器人“小源”，提供高效、权威、准确的疫情防护问答服务；通过积极参与开源社区建设并贡献技术力量，微软已经在国内外开源社区中赢得了广泛的认可。

微软开源的Visual Studio Code也在中国开源界发挥了巨大的作用，大量的中国开发者使用Visual Studio Code开发自己的开源项目、开发基于Visual Studio Code的开源插件。Visual Studio Code成 为中国开源社区的重要组成部分。不仅如此，微软推出的TypeScript广受社区开发者的好评，成为业界JavaScript类型化的事实标准，中国开发者基于TypeScript开发出大量的优秀开源项目。

在云原生领域，微软积极参与到社区开源软件的开发和维护当中，作为CNCF基金会的白金会员，为CNCF捐赠和贡献了Kubernetes、etcd、containerd、Helm、KEDA、Virtual Kubelet、Open Service Mesh等项目。

在Kubernetes联合创始人Brendan Burns的带领下，微软常年位居Kubernetes项目的贡献者前列，累计为Kubernetes提供了超过10万次的贡献。除了参与到核心项目构建当中，微软还开源了不少云原生场景下的计算组件，帮助中国开发者更好地在社区、企业等不同规模的场景中落地云原生。

2018年，微软将收购而来的Helm捐赠给CNCF基金会，让开发者在使用Helm时再无后顾之忧；随之而来的是，微软在2019年开源了一套跨场景的分布式运行时Dapr，为中国开发者提供了应用程序的无侵入式分布式开发体验，帮助开发者更好地落地业务和应用。国内诸如阿里巴巴等企业也在自己的业务系统当中大量应用Dapr。2020年，微软开源了一套轻量级服务网格组件Open Service Mesh，并将其捐赠给CNCF基金会，帮助广大的中国开发者可以用更低成本落地服务治理，助力开发者落地微服务。

开源的影响无处不在，势不可挡，但开源不仅仅是软件和技术层面，更是工程师文化。微软会持续加大对于开源社区的投入。同时，微软在中国将继续致力于帮助中国的开源社区与全球的开源组织合作，将优秀的开源项目和文化引进中国，推动中国的开源活动和开源精神的发展；微软也会继续加速将中国的优秀开源文化、开源活动传播出去，让中国的开源文化得以被全世界的开发者们所知晓。

### 9.5.6 红帽对中国开源的贡献

如今，IT的发展与技术使用，已经不是由某个厂商所主导。借助开源开放的思想与工具，用户开始掌握未来发展的选择权与控制权。

技术方面，红帽为中国企业用户提供企业级开源解决方案，依托社区支持，为客户提供Linux、混合云、容器和Kubernetes技术，涵盖数据中心到网络边缘领域；人才培养上，培养开源新生力量和企业IT中坚力量，赋能IT决策者和管理者。

2011年起，针对全国大专院校计算机/软件专业学生，红帽已连续10年举办“红帽挑战赛”活动，基于广受赞誉的红帽开源软件技术培训服务，联合30多家合作伙伴，以及数百家大专院校，共同为国内培养开源软件后备专业人才，迄今已有8万余名高校学生参与其中。

2020和2021年，红帽联合国内各行业企业用户，知名企业IT社区及国内外生态合作伙伴，共同成功举办了两届覆盖全国/全行业的“容器云职业技能大赛”，极大推动了全球最先进的容器化技术在国内的发展进程。每年都有近4000家来自银行、保险、证券、电信、制造、医疗等行业的企业用户参与，两年总计近50,000人参与大赛学习，数千人参加了最后阶段的精英比赛，并获得专业技术认证，数十个团队获奖并沉淀了近百个容器技术实践方案。

红帽中国积极利用在国际开源社区的经验、资源和影响力，支持国内开源社区及国内先行企业与国际开源社区交流合作(如OpenStack、Ceph等技术领域)，安排各类红帽技术专家，积极参与各种国际开源社区在国内的用户组组织的的技术交流活动。

自2004年至今，东北亚开源软件推进论坛一直连续成功举办，论坛旨在积极促进中日韩三国、东北亚地区以及世界开源软件的合作与发展。为此，论坛设立了四个工作组，分别负责技术开发与评估、人才培养与激励、标准制定与认定，以及应用推广与协调。红帽中国一直参与第三工作组的工作，积极利用在开源方面的经验和优势帮助东北亚开源联盟制定标准。

**红帽对中国开源的建议**

树立起开源文化核心三观：要有全球视野、融合发展、开放心态、协作精神的世界观；其次是既要拿来，又要贡献的价值观；最后是有追求、有信仰、我为人人、人人为我的人生观。

